/*
 * Decompiled with CFR 0.152.
 */
package gr.gspr.webservicealldatadesktopclient.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.ImageIcon;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Utils {
    public static final String xml = "xml";
    public static final String pdf = "pdf";
    public static final String jpg = "jpg";
    public static final String jpeg = "jpeg";
    public static final String tiff = "tiff";
    public static final String tif = "tif";
    public static final String zip = "zip";
    public static final String xls = "xls";
    public static final String xlsx = "xlsx";
    public static final String csv = "csv";
    private static final String charset = "0123456789";
    private static final String charset2 = "\u0391\u0392\u0393\u0394\u0395\u0396\u0397\u0398\u0399\u039a\u039b\u039c\u039d\u039e\u039f\u03a0\u03a1\u03a3\u03a4\u03a5\u03a6\u03a7\u03a8\u03a9";

    public static String getRandomString(int length, String charSet) {
        Random rand = new Random(System.currentTimeMillis());
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            int pos = rand.nextInt(charSet.length());
            sb.append(charSet.charAt(pos));
        }
        return sb.toString();
    }

    public static String makeZeros(int zeronum) {
        String zeros = "";
        for (int i = 1; i <= zeronum; ++i) {
            zeros = zeros + "0";
        }
        return zeros;
    }

    public static Element createElement(Node f) {
        Element element = (Element)f;
        return element;
    }

    public static String getExtension(File f) {
        String ext = null;
        String s = f.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    public static String substituteString(String texttbp, String stbefore, String stafter) {
        String tbptext = texttbp;
        int i = 0;
        boolean j = false;
        while (tbptext.indexOf(stbefore) != -1) {
            i = tbptext.indexOf(stbefore);
            String part1 = tbptext.substring(0, i);
            String part2 = tbptext.substring(part1.length() + stbefore.length(), tbptext.length());
            tbptext = part1 + stafter + part2;
        }
        return tbptext;
    }

    protected static ImageIcon createImageIcon(String path) {
        URL imgURL = Utils.class.getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        }
        System.err.println("Couldn't find file: " + path);
        return null;
    }

    public static void createFiles(File f) {
        try {
            if (!f.getParentFile().exists()) {
                Utils.createParents(f.getParentFile());
                f.createNewFile();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void createParents(File file) {
        if (!file.exists()) {
            Utils.createParents(file.getParentFile());
            file.mkdir();
        }
    }

    public static boolean isEmailValid(String email) {
        boolean isValid = false;
        String expression = "^[\\w\\.-]+@([\\w\\-]+\\.)+[A-Z]{2,4}$";
        String inputStr = email;
        Pattern pattern = Pattern.compile(expression, 2);
        Matcher matcher = pattern.matcher(inputStr);
        if (matcher.matches()) {
            isValid = true;
        }
        return isValid;
    }

    public static boolean unzip(ZipInputStream zis, String dir_for_output, Enumeration entries) {
        try {
            int len;
            ZipEntry entry = zis.getNextEntry();
            if (entry == null) {
                zis.close();
                return true;
            }
            ZipEntry ent = (ZipEntry)entries.nextElement();
            int size = (int)ent.getSize();
            String filename = dir_for_output + File.separatorChar + entry.getName();
            Utils.createFiles(new File(filename));
            FileOutputStream fos = new FileOutputStream(filename);
            byte[] buffer = new byte[65535];
            while ((len = zis.read(buffer)) != -1) {
                fos.write(buffer, 0, len);
            }
            fos.flush();
            fos.close();
            boolean resultOfMoreCalls = Utils.unzip(zis, dir_for_output, entries);
            if (!resultOfMoreCalls) {
                return false;
            }
        }
        catch (Exception x) {
            x.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean inDateRange(Calendar dateToBeChecked, Calendar dateFrom, Calendar dateTo) {
        if (dateToBeChecked == null) {
            return false;
        }
        return dateToBeChecked.compareTo(dateFrom) >= 0 && dateToBeChecked.compareTo(dateTo) <= 0;
    }

    public static boolean checkAFM(String afm) {
        int i;
        if (afm == null) {
            return false;
        }
        if (afm.equals("000000000")) {
            return false;
        }
        String chkafm = "afm accepted";
        int[] afmdigits = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0};
        boolean afmchk = true;
        boolean afmchkletter = true;
        boolean afmchkdigit = true;
        int sum = 0;
        for (i = 0; i < afm.length(); ++i) {
            if (Character.isDigit(afm.charAt(i))) continue;
            afmchkletter = false;
        }
        if (afmchkletter) {
            if (afm.length() != 9 || afm.equals("")) {
                afmchk = false;
                afmchkdigit = false;
            } else {
                for (i = 0; i < 8; ++i) {
                    afmdigits[i] = Integer.valueOf(afm.substring(i, i + 1));
                    sum += afmdigits[i] * (int)Math.pow(2.0, 8 - i);
                }
                afmdigits[8] = Integer.valueOf(afm.substring(8, 9));
                int ypol = sum % 11;
                if (ypol == 10 && afmdigits[8] != 0 || ypol < 10 && ypol != afmdigits[8]) {
                    afmchk = false;
                }
            }
        }
        boolean result = afmchk && afmchkletter && afmchkdigit;
        return result;
    }

    public static boolean checkDate(String dateString) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
            Date dat1 = sdf.parse(dateString);
            return true;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean checkInt(String intString) {
        try {
            Integer.parseInt(intString);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static Date toMidnight(Date incomingDate) throws Exception {
        Calendar cal = Calendar.getInstance();
        cal.setTime(incomingDate);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 999);
        return cal.getTime();
    }

    public static String convertCharsets(String fromCharset, String toCharset, String instring) {
        String outstring = "";
        if (instring == null) {
            return instring;
        }
        byte[] bs = null;
        try {
            bs = instring.getBytes(fromCharset);
            outstring = new String(bs, toCharset);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return outstring;
    }

    public static boolean isBeforeDeadline(Date deadline) {
        Calendar deadlineCal = Calendar.getInstance();
        deadlineCal.setTime(deadline);
        Calendar currentDate = Calendar.getInstance();
        currentDate.setTime(new Date());
        return !currentDate.after(deadlineCal);
    }

    public static boolean checkAMKA(String amka) {
        int i;
        if (amka == null) {
            return false;
        }
        int[] amkadigits = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        boolean amkachk = true;
        boolean amkachkletter = true;
        boolean amkachkday = true;
        boolean amkachkmonth = true;
        int sum = 0;
        for (i = 0; i < amka.length(); ++i) {
            if (Character.isDigit(amka.charAt(i))) continue;
            amkachkletter = false;
        }
        if (amkachkletter) {
            if (amka.length() != 11 || amka.equals("")) {
                amkachk = false;
                amkachkletter = false;
            } else {
                for (i = 0; i < 10; ++i) {
                    amkadigits[i] = Integer.valueOf(amka.substring(i, i + 1));
                    if (i % 2 == 1) {
                        if (amkadigits[i] < 5) {
                            sum += amkadigits[i] * 2;
                            continue;
                        }
                        sum = sum + 1 + amkadigits[i] * 2 % 10;
                        continue;
                    }
                    sum += amkadigits[i];
                }
                int checkDigit = Integer.valueOf(amka.substring(10, 11));
                int ypol = 10 - sum % 10;
                if (ypol == 10 && checkDigit != 0 || ypol != 10 && ypol != checkDigit) {
                    amkachk = false;
                }
            }
            if (amkachk && amkachkletter) {
                int month;
                int day = Integer.valueOf(amka.substring(0, 2));
                if (day > 31 || day < 0) {
                    amkachkday = false;
                }
                if ((month = Integer.valueOf(amka.substring(2, 4)).intValue()) > 12 || month < 1) {
                    amkachkmonth = false;
                }
            }
        }
        boolean result = amkachk && amkachkletter && amkachkday && amkachkmonth;
        return result;
    }

    public static String removeOneAccent(String lexi, String gramma, String neogramma) {
        while (lexi.indexOf(gramma) >= 0) {
            lexi = lexi.substring(0, lexi.indexOf(gramma)) + neogramma + lexi.substring(lexi.indexOf(gramma) + 1, lexi.length());
        }
        return lexi;
    }
}

