/*
 * Apache License, Version 2.0
 */

package gr.gspr.webservicealldatadesktopclient;

import gr.gspr.webservicealldatadesktopclient.client2.GenWsErrorRtType;
import gr.gspr.webservicealldatadesktopclient.client2.ObjectFactory;
import gr.gspr.webservicealldatadesktopclient.client2.RgWsPublic2AfmCalledByRtType;
import gr.gspr.webservicealldatadesktopclient.client2.RgWsPublic2AfmMethodResponseType.Result;
import gr.gspr.webservicealldatadesktopclient.client2.RgWsPublic2BasicRtType;
import gr.gspr.webservicealldatadesktopclient.client2.RgWsPublic2FirmActRtType;
import gr.gspr.webservicealldatadesktopclient.client2.RgWsPublic2InputRtType;
import gr.gspr.webservicealldatadesktopclient.client2.RgWsPublic2ResultRtType;
import gr.gspr.webservicealldatadesktopclient.client2.RgWsPublic2Service;
import gr.gspr.webservicealldatadesktopclient.client2.RgWsPublic2ServiceInterface;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.ws.Holder;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.HandlerResolver;
import javax.xml.ws.handler.PortInfo;

/**
 *
 * @author j.vlachos@aade.gr
 */
public class ServiceClient2 {
    //call to get the version of the web service
    public String getVersion(){
        String version="not found";
        
        RgWsPublic2Service service=new RgWsPublic2Service();
        
        RgWsPublic2ServiceInterface rg= service.getRgWsPublic2ServicePort();
        version=rg.rgWsPublic2VersionInfo();
        
        return version;
    }
    
  
    
    //call to get the data for a tin 
    public String getData(String un, String pass,String afm, String afmDelegator, Date as_on_date){
        String data="not found";
        
        
        RgWsPublic2Service service=new RgWsPublic2Service();
        //put username and password in call
        final MySOAPHandler mySoapHandler=new MySOAPHandler();
        mySoapHandler.setPassWord((String) pass);
        mySoapHandler.setUserName((String) un);
        
        service.setHandlerResolver(new HandlerResolver() {
            @Override
            public List<Handler> getHandlerChain(PortInfo portInfo) {
                List<Handler> handlerList = new ArrayList<Handler>();
                
                handlerList.add(mySoapHandler);
                return handlerList;
            }
        });
        
        
        RgWsPublic2ServiceInterface rg= service.getRgWsPublic2ServicePort();
        
        RgWsPublic2InputRtType inputRtUser=new RgWsPublic2InputRtType();
        ObjectFactory obj=new ObjectFactory();
        
        JAXBElement<String> jaxbElement = obj.createRgWsPublic2InputRtTypeAfmCalledBy(afmDelegator);
        inputRtUser.setAfmCalledBy(jaxbElement);
        jaxbElement = obj.createRgWsPublic2InputRtTypeAfmCalledFor(afm);
        inputRtUser.setAfmCalledFor(jaxbElement);
        
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(as_on_date);
        try{
            JAXBElement<XMLGregorianCalendar> jaxbdate=obj.createRgWsPublic2InputRtTypeAsOnDate(DatatypeFactory.newInstance().newXMLGregorianCalendar(cal));
            inputRtUser.setAsOnDate(jaxbdate);
        }catch(Exception e){
            
        }
        
        
        BigDecimal pCSIO=new BigDecimal(0);
        Holder<BigDecimal> pCallSeqIdOut=new Holder<BigDecimal>(pCSIO);
        
        GenWsErrorRtType pERO=new GenWsErrorRtType();
        
        
        Holder<GenWsErrorRtType> pErrorRecOut=new Holder<GenWsErrorRtType>(pERO);
        
        Result result=rg.rgWsPublic2AfmMethod(inputRtUser);
        
        RgWsPublic2ResultRtType res = result.getRgWsPublic2ResultRtType();
        
        
        
        GenWsErrorRtType errorreturned=res.getErrorRec();
        String err=errorreturned.getErrorDescr().getValue();
        
        RgWsPublic2BasicRtType basicRtUser=res.getBasicRec();
        //for userinfo
        RgWsPublic2AfmCalledByRtType userinfo = res.getAfmCalledByRec();
        
        
        
        //if there are not any errors, show the data
        if ((err==null) || (err.isEmpty())){
            
            String returndata="";
            returndata=returndata+"Ημερομηνία αναφοράς: "+userinfo.getAsOnDate().getValue().getDay()+"/"+userinfo.getAsOnDate().getValue().getMonth()+"/"+userinfo.getAsOnDate().getValue().getYear()+"\r\n";
            returndata=returndata+"Ονοματεπώνυμο/Επωνυμία: "+basicRtUser.getOnomasia().getValue()+"\r\n";
            returndata=returndata+"ΑΦΜ: "+basicRtUser.getAfm().getValue()+"\r\n";
            if ((basicRtUser.getCommerTitle().getValue()!=null) && (!basicRtUser.getCommerTitle().getValue().trim().isEmpty()))
                returndata=returndata+"Τίτλος επιχείρησης: "+basicRtUser.getCommerTitle().getValue()+"\r\n";
            returndata=returndata+"Φυσικό/Μη φυσικό πρόσωπο: "+basicRtUser.getINiFlagDescr().getValue()+"\r\n";
            if ((basicRtUser.getLegalStatusDescr().getValue()!=null) && (!basicRtUser.getLegalStatusDescr().getValue().trim().isEmpty())){
                returndata=returndata+"Μορφή Μη ΦΠ: "+basicRtUser.getLegalStatusDescr().getValue()+"\r\n";
            }
            returndata=returndata+"ΔΟΥ: "+basicRtUser.getDoyDescr().getValue()+" ("+basicRtUser.getDoy().getValue()+")\r\n";
           
            returndata=returndata+basicRtUser.getDeactivationFlagDescr().getValue()+"\r\n";
            
            returndata=returndata+basicRtUser.getFirmFlagDescr().getValue()+"\r\n";
            
            try{
                returndata=returndata+"Διεύθυνση: "+basicRtUser.getPostalAddress().getValue().trim()+" "+basicRtUser.getPostalAddressNo().getValue().trim()+", "+basicRtUser.getPostalAreaDescription().getValue().trim()+", "+basicRtUser.getPostalZipCode().getValue().trim()+"\r\n";
            }catch(Exception e){
                //No address
            }
            
            //Dates:
            String regDate="";
            try{
                regDate=basicRtUser.getRegistDate().getValue().getDay()+"-"+basicRtUser.getRegistDate().getValue().getMonth()+"-"+basicRtUser.getRegistDate().getValue().getYear();
             }catch(Exception e){
                //No regDate
            }      
            
            if (!regDate.isEmpty()){
                returndata=returndata+"Ημ/νία Έναρξης: "+regDate+"\r\n";
            }
            
            String endDate="";
            try{
                endDate=basicRtUser.getStopDate().getValue().getDay()+"-"+basicRtUser.getStopDate().getValue().getMonth()+"-"+basicRtUser.getStopDate().getValue().getYear();
             }catch(Exception e){
                //No regDate
            }      
            
            if (!endDate.isEmpty()){
                returndata=returndata+"Ημ/νία Διακοπής: "+endDate+"\r\n";
            }
            
            String vat="";
            
            String temp=basicRtUser.getNormalVatSystemFlag().getValue();
            if (temp.equals("Y")){
                vat="Κανονικό Καθεστώς Φ.Π.Α.: NAI";
            }else if (temp.equals("N")){
                vat="Κανονικό Καθεστώς Φ.Π.Α.: OXI";
            }
            
            if (!vat.isEmpty()){
                returndata=returndata+vat+"\r\n";
            }
            
            //ΔΡΑΣΤΗΡΙΟΤΗΤΕΣ ΕΠΙΧΕΙΡΗΣΗΣ
            try{
                List<RgWsPublic2FirmActRtType> rtUserArray= res.getFirmActTab().getItem();
                 if ((rtUserArray!=null) && (!rtUserArray.isEmpty())) {
                     
                     returndata=returndata+"\r\n"+"ΔΡΑΣΤΗΡΙΟΤΗΤΕΣ ΕΠΙΧΕΙΡΗΣΗΣ:"+"\r\n";
                     for (RgWsPublic2FirmActRtType rtUser:rtUserArray){
                         returndata=returndata+rtUser.getFirmActCode().getValue()+"-"+rtUser.getFirmActDescr().getValue() +" ("+rtUser.getFirmActKindDescr().getValue()+")\r\n";
                     }
                 }
            }catch(Exception e){
                System. out.println("Δεν υπάρχουν δραστηριότητες.");
            }
            
            
            try{
                String userinfocaller ="ΑΦΜ: "+ userinfo.getTokenAfm().getValue()+ " Ονομ/μο: " + userinfo.getTokenAfmFullname().getValue();
                MainFrame.userinfo=userinfocaller;
                //exousiodotisi:
                if (afmDelegator!= null && !afmDelegator.isEmpty()){
                    String userinfoexousiodotisi =" Ονομ/μο: " + userinfo.getAfmCalledByFullname().getValue();
                    MainFrame.exousiodotisiinfo=userinfoexousiodotisi;
                }else{
                    MainFrame.exousiodotisiinfo="";
                }
            }catch(Exception e){

            }
            
            
            return returndata;
        }else{
            try{
                if ((userinfo.getTokenAfm().getValue()!=null) && !userinfo.getTokenAfm().getValue().isEmpty()){
                    String userinfocaller ="ΑΦΜ: "+ userinfo.getTokenAfm().getValue()+ " Ονομ/μο: " + userinfo.getTokenAfmFullname().getValue();
                    MainFrame.userinfo=userinfocaller;
                }else{
                    MainFrame.userinfo="";
                }
                //exousiodotisi:
                if (afmDelegator!= null && !afmDelegator.isEmpty()){
                    if ((userinfo.getAfmCalledByFullname().getValue()!=null) && !userinfo.getAfmCalledByFullname().getValue().isEmpty()){
                        String userinfoexousiodotisi =" Ονομ/μο: " + userinfo.getAfmCalledByFullname().getValue();
                        MainFrame.exousiodotisiinfo=userinfoexousiodotisi;
                    }else{
                        MainFrame.exousiodotisiinfo="";
                    }
                }else{
                    MainFrame.exousiodotisiinfo="";
                }
            }catch(Exception e){

            }
            return err;
        }
        
        
       
    }
}
